<?php 
session_start();
// Cek apakah sudah login? Kalau belum, tendang balik ke login
if($_SESSION['status']!="login"){
    header("location:login.php?pesan=belum_login");
}
include 'koneksi.php';
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin - Math Fair 2026</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <style>
        body { background-color: #f4f6f9; font-family: 'Poppins', sans-serif; }
        .sidebar { background: #6d1b1b; min-height: 100vh; color: white; }
        .nav-link { color: rgba(255,255,255,0.8); margin-bottom: 5px; }
        .nav-link:hover, .nav-link.active { color: white; background: rgba(255,255,255,0.1); border-radius: 10px; }
        .card-dashboard { border: none; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .thumb-img { width: 50px; height: 50px; object-fit: cover; border-radius: 8px; cursor: pointer; border: 1px solid #ddd; }
        .thumb-img:hover { transform: scale(1.1); transition: 0.2s; }
        .badge-pending { background: #ffeeba; color: #856404; border: 1px solid #ffeeba; }
        .badge-lunas { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-2 sidebar p-4 d-none d-md-block">
            <h4 class="fw-bold mb-4"><i class="bi bi-shield-lock"></i> ADMIN PANEL</h4>
            <div class="d-flex align-items-center mb-4">
                <div class="bg-white text-danger rounded-circle d-flex align-items-center justify-content-center fw-bold" style="width: 40px; height: 40px;">
                    <?php echo substr($_SESSION['username'], 0, 1); ?>
                </div>
                <div class="ms-2">
                    <small class="d-block text-white-50">Halo,</small>
                    <span class="fw-bold"><?php echo $_SESSION['username']; ?></span>
                </div>
            </div>
            
            <nav class="nav flex-column">
                <a class="nav-link active" href="admin.php"><i class="bi bi-grid-fill me-2"></i> Data Peserta</a>
                <a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a>
            </nav>
        </div>

        <div class="col-md-10 p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h3 class="fw-bold text-dark">Data Peserta Masuk</h3>
                <a href="admin.php" class="btn btn-outline-secondary btn-sm"><i class="bi bi-arrow-clockwise"></i> Refresh</a>
            </div>

            <div class="card card-dashboard p-4">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>No</th>
                                <th>Bukti & Berkas</th>
                                <th>Identitas Peserta</th>
                                <th>Kategori</th>
                                <th>Kontak</th>
                                <th>Status</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            // AMBIL DATA DARI DATABASE (Digabung dengan tb_lomba biar nama lombanya muncul)
                            // Jika belum ada tb_lomba, pake query biasa: SELECT * FROM tb_pendaftar ORDER BY id_pendaftar DESC
                            $query = mysqli_query($koneksi, "SELECT * FROM tb_pendaftar ORDER BY id_pendaftar DESC");
                            
                            $no = 1;
                            while($d = mysqli_fetch_array($query)){
                                // Tentukan Nama Lomba Manual (Kalau belum join tabel)
                                $nama_lomba = "Lomba ID: " . $d['id_lomba'];
                                if($d['id_lomba'] == 1) $nama_lomba = '<span class="badge bg-warning text-dark">Olimpiade SD</span>';
                                if($d['id_lomba'] == 2) $nama_lomba = '<span class="badge bg-warning text-dark">Olimpiade SMP</span>';
                                if($d['id_lomba'] == 3) $nama_lomba = '<span class="badge bg-warning text-dark">Olimpiade SMA</span>';
                                if($d['id_lomba'] == 4) $nama_lomba = '<span class="badge bg-danger">LCCM (Tim)</span>';
                                if($d['id_lomba'] == 5) $nama_lomba = '<span class="badge bg-primary">SIC (Tim)</span>';
                                // ... tambahkan ID lain sesuai database kamu
                            ?>
                            <tr>
                                <td><?php echo $no++; ?></td>
                                
                                <td>
                                    <div class="d-flex gap-2">
                                        <div class="text-center">
                                            <a href="uploads/<?php echo $d['bukti_bayar']; ?>" target="_blank">
                                                <img src="uploads/<?php echo $d['bukti_bayar']; ?>" class="thumb-img" alt="Bayar">
                                            </a>
                                            <div style="font-size:10px;">Bayar</div>
                                        </div>
                                        <div class="text-center">
                                            <a href="uploads/<?php echo $d['foto_peserta']; ?>" target="_blank">
                                                <img src="uploads/<?php echo $d['foto_peserta']; ?>" class="thumb-img" alt="Peserta">
                                            </a>
                                            <div style="font-size:10px;">Siswa</div>
                                        </div>
                                    </div>
                                </td>

                                <td>
                                    <span class="fw-bold d-block text-uppercase"><?php echo $d['nama_peserta']; ?></span>
                                    <small class="text-muted"><i class="bi bi-building"></i> <?php echo $d['asal_sekolah']; ?></small>
                                    <br>
                                    <small class="text-primary" style="font-size: 0.75rem;">Reg: <?php echo $d['kode_registrasi']; ?></small>
                                </td>

                                <td><?php echo $nama_lomba; ?></td>

                                <td>
                                    <a href="https://wa.me/62<?php echo $d['no_wa']; ?>" target="_blank" class="btn btn-success btn-sm rounded-pill">
                                        <i class="bi bi-whatsapp"></i> Chat
                                    </a>
                                    <div class="small mt-1 text-muted"><?php echo $d['no_wa']; ?></div>
                                </td>

                                <td>
                                    <?php if($d['status_pendaftaran'] == 'Lunas'){ ?>
                                        <span class="badge badge-lunas px-3 py-2"><i class="bi bi-check-circle-fill"></i> Lunas</span>
                                    <?php } else { ?>
                                        <span class="badge badge-pending px-3 py-2"><i class="bi bi-hourglass-split"></i> Pending</span>
                                    <?php } ?>
                                </td>

                                <td>
                                    <div class="d-grid gap-1">
                                        <?php if($d['status_pendaftaran'] != 'Lunas'){ ?>
                                            <a href="verifikasi.php?id=<?php echo $d['id_pendaftar']; ?>" class="btn btn-primary btn-sm" onclick="return confirm('Yakin validasi data ini?')">
                                                <i class="bi bi-check-lg"></i> Validasi
                                            </a>
                                        <?php } ?>
                                        
                                        <a href="hapus.php?id=<?php echo $d['id_pendaftar']; ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Yakin hapus data ini?')">
                                            <i class="bi bi-trash"></i> Hapus
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                    
                    <?php if(mysqli_num_rows($query) == 0) { ?>
                        <div class="text-center py-5 text-muted">
                            <i class="bi bi-inbox fs-1"></i>
                            <p>Belum ada pendaftar masuk.</p>
                        </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>