<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matematika Fair 2026 - The Royal Event</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;600;800&family=Playfair+Display:ital,wght@0,400;0,700;1,400&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <style>
        :root { 
            --primary: #6d1b1b; 
            --primary-dark: #4a0d0d;
            --gold: #d4af37; 
            --gold-light: #f9eac3;
            --cream: #fdfbf7; 
            --dark: #1a1a1a; 
        }
        
        body { 
            background-color: var(--cream); 
            font-family: 'Poppins', sans-serif; 
            overflow-x: hidden; 
            color: #333;
        }
        
        /* --- TYPOGRAPHY --- */
        h1, h2, h3, h4, h5 { font-family: 'Cinzel', serif; letter-spacing: 1px; }
        .text-gold { color: var(--gold) !important; }
        .text-maroon { color: var(--primary) !important; }
        
        /* --- NAVBAR GLASSMORPHISM --- */
        .navbar { 
            background: rgba(255, 255, 255, 0.9); 
            backdrop-filter: blur(20px); 
            border-bottom: 1px solid rgba(212, 175, 55, 0.3); 
            padding: 15px 0;
            transition: 0.3s;
        }
        .logo-img { height: 55px; width: auto; transition: 0.3s; object-fit: contain; mix-blend-mode: multiply; } 
        .logo-img:hover { transform: scale(1.1); filter: drop-shadow(0 0 5px rgba(212, 175, 55, 0.5)); }
        .nav-link { 
            color: var(--primary) !important; 
            font-weight: 600; 
            text-transform: uppercase; 
            font-size: 0.85rem; 
            letter-spacing: 1px;
            position: relative;
            padding: 5px 10px;
        }
        .nav-link::after {
            content: ''; position: absolute; width: 0; height: 2px; 
            bottom: 0; left: 0; background-color: var(--gold); 
            transition: width 0.3s;
        }
        .nav-link:hover::after { width: 100%; }
        
        /* --- HERO SECTION --- */
        .hero-section { 
            padding-top: 160px; 
            padding-bottom: 100px; 
            min-height: 100vh; 
            display: flex; 
            align-items: center;
            background: radial-gradient(circle at top right, rgba(212, 175, 55, 0.1), transparent 40%),
                        radial-gradient(circle at bottom left, rgba(109, 27, 27, 0.05), transparent 40%);
        }
        .title-hero {
            font-weight: 900; 
            line-height: 1.1;
            background: linear-gradient(45deg, var(--primary), #800000);
            -webkit-background-clip: text; 
            -webkit-text-fill-color: transparent;
            font-size: 4rem;
            text-shadow: 2px 2px 20px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .lead-text {
            font-family: 'Playfair Display', serif;
            font-style: italic;
            font-size: 1.25rem;
            color: #555;
        }
        
        /* --- BUTTONS --- */
        .btn-custom-red {
            background: linear-gradient(45deg, var(--primary), #902e2e);
            border: none; color: white; padding: 12px 35px;
            border-radius: 50px; font-weight: 600; letter-spacing: 1px;
            box-shadow: 0 10px 20px rgba(109, 27, 27, 0.3);
            transition: 0.3s;
        }
        .btn-custom-red:hover { transform: translateY(-3px); box-shadow: 0 15px 25px rgba(109, 27, 27, 0.4); color: white; }
        
        .btn-custom-gold {
            background: linear-gradient(45deg, #d4af37, #f3c658);
            border: none; color: white; padding: 12px 35px;
            border-radius: 50px; font-weight: 600; letter-spacing: 1px;
            box-shadow: 0 10px 20px rgba(212, 175, 55, 0.3);
            transition: 0.3s;
        }
        .btn-custom-gold:hover { transform: translateY(-3px); box-shadow: 0 15px 25px rgba(212, 175, 55, 0.4); color: white; }

        .btn-outline-dark-custom {
            border: 2px solid var(--dark); color: var(--dark);
            padding: 10px 30px; border-radius: 50px; font-weight: 600;
            transition: 0.3s;
        }
        .btn-outline-dark-custom:hover { background: var(--dark); color: white; }

        /* --- CARDS & BOXES --- */
        .glass-card {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.5);
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.05);
            transition: 0.3s;
            height: 100%;
        }
        .glass-card:hover { transform: translateY(-5px); box-shadow: 0 20px 40px rgba(109, 27, 27, 0.1); border-color: var(--gold); }
        
        .poster-frame { 
            border: 8px solid white; 
            box-shadow: 0 20px 50px rgba(0,0,0,0.2); 
            border-radius: 20px; 
            transition: 0.5s; 
            transform: rotate(-2deg);
        }
        .poster-frame:hover { transform: rotate(0deg) scale(1.02); }

        /* --- GALLERY SPECIAL MOMENTS --- */
        .gallery-img {
            width: 100%; height: 250px; object-fit: cover;
            border-radius: 15px; border: 3px solid white;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            transition: 0.4s; filter: grayscale(20%);
        }
        .gallery-img:hover {
            transform: scale(1.05); filter: grayscale(0%);
            border-color: var(--gold); z-index: 2;
        }

        /* --- TIMELINE --- */
        .timeline-card { 
            background: white; border-radius: 15px; padding: 25px; 
            border-left: 5px solid var(--gold); 
            box-shadow: 0 10px 30px rgba(0,0,0,0.05); 
            height: 100%; transition: 0.3s; 
        }
        .timeline-card:hover { transform: translateY(-5px); box-shadow: 0 15px 40px rgba(0,0,0,0.1); }
        .date-badge { 
            background: var(--gold); color: white; padding: 2px 8px; 
            border-radius: 4px; font-size: 0.75rem; font-weight: bold; 
            margin-right: 8px; display: inline-block; min-width: 80px; text-align: center;
        }
        .timeline-list li { margin-bottom: 12px; font-size: 0.9rem; border-bottom: 1px dashed #eee; padding-bottom: 5px; }

        /* --- MASKOT --- */
        .maskot-frame { max-height: 450px; filter: drop-shadow(0 15px 30px rgba(0,0,0,0.2)); animation: float 4s ease-in-out infinite; }
        @keyframes float { 0%, 100% { transform: translateY(0px); } 50% { transform: translateY(-15px); } }

        /* --- SECTION TITLES --- */
        .section-header { text-align: center; margin-bottom: 50px; }
        .section-header h2 { font-size: 2.5rem; color: var(--primary); font-weight: 800; margin-bottom: 15px; }
        .divider-gold { height: 4px; width: 80px; background: var(--gold); margin: 0 auto; border-radius: 2px; }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .hero-section { text-align: center; padding-top: 120px; }
            .title-hero { font-size: 2.8rem; }
            .logo-group { justify-content: center !important; margin-bottom: 10px; }
            .poster-frame { margin-top: 40px; max-height: 400px; }
        }
    </style>
</head>
<body>

    <nav class="navbar navbar-expand-lg fixed-top shadow-sm">
        <div class="container">
            <a class="navbar-brand d-flex flex-column flex-md-row align-items-center" href="#">
                <div class="d-flex align-items-center gap-2 logo-group">
                    <img src="assets/img/logo_unimed.jpg" class="logo-img" alt="Unimed">
                    <img src="assets/img/logo_hmj.jpeg" class="logo-img" alt="HMJ">
                    <img src="assets/img/logo_mathfair.jpeg" class="logo-img" alt="MathFair">
                </div>
                <div class="ms-md-3 mt-2 mt-md-0 lh-1 text-center text-md-start">
                    <span class="fw-bold d-block text-dark" style="font-family:'Cinzel'; font-size:1.2rem; letter-spacing: 1px;">HMJ MATEMATIKA</span>
                    <span class="fw-bold d-block text-secondary" style="font-size:0.75rem; font-family:'Poppins'; letter-spacing: 2px;">MATEMATIKA FAIR 2026</span>
                </div>
            </a>
            
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <i class="bi bi-list fs-1 text-primary"></i>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto gap-3 align-items-center">
                    <li class="nav-item"><a class="nav-link" href="#home">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="#tentang">Tentang</a></li>
                    <li class="nav-item"><a class="nav-link" href="#galeri">Galeri</a></li>
                    <li class="nav-item"><a class="nav-link" href="#kategori">Lomba</a></li>
                    <li class="nav-item"><a class="nav-link" href="#timeline">Jadwal</a></li>
                    <li class="nav-item"><a class="btn btn-outline-danger btn-sm rounded-pill px-4 fw-bold" href="login.php">Login Panitia</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <section id="home" class="hero-section">
        <div class="container">
            <div class="row align-items-center flex-column-reverse flex-lg-row">
                <div class="col-lg-6 mt-5 mt-lg-0" data-aos="fade-right">
                    <div class="d-inline-block border border-warning text-warning px-3 py-1 rounded-pill mb-3 small fw-bold shadow-sm" style="background: white;">
                        <i class="bi bi-trophy-fill"></i> #1 BIGGEST MATH EVENT IN SUMATRA
                    </div>
                    <h1 class="title-hero">MATEMATIKA<br>FAIR 2026</h1>
                    <p class="lead-text my-4">
                        "ChronoMath: Journey of Numbers Through Time"<br>
                        <span class="fs-6 font-poppins text-muted fst-normal">Jelajahi keajaiban angka, ukir prestasi, dan jadilah saksi sejarah di kompetisi matematika paling bergengsi tahun ini!</span>
                    </p>
                    
                    <div class="d-flex flex-column flex-md-row gap-3">
                        <a href="pilih_lomba.php" class="btn-custom-red shadow">
                            DAFTAR SEKARANG <i class="bi bi-arrow-right-circle ms-2"></i>
                        </a>
                        <a href="#kategori" class="btn-outline-dark-custom">
                            Info Lomba
                        </a>
                    </div>

                    <div class="mt-4 pt-3 border-top border-secondary-subtle" data-aos="fade-up" data-aos-delay="200">
                        <p class="small text-muted mb-2 fw-bold text-uppercase ls-1">Persiapan Lomba:</p>
                        <a href="https://drive.google.com/drive/folders/1l4W2mvm6KqOuobod8E8srrCNgBVAxPBk" target="_blank" class="btn-custom-gold w-100 w-md-auto text-decoration-none d-inline-flex align-items-center justify-content-center">
                            <i class="bi bi-file-earmark-pdf-fill me-2 fs-5"></i> DOWNLOAD SILABUS & PANDUAN
                        </a>
                    </div>
                </div>

                <div class="col-lg-6 position-relative" data-aos="fade-left" data-aos-duration="1200">
                    <div class="col-lg-6 d-flex justify-content-center" data-aos="fade-left" data-aos-duration="1200">
                    
                    <div class="ticket-wrapper" style="perspective: 1000px;">
                        
                        <div class="glass-ticket p-4 position-relative" style="
                            width: 100%; 
                            max-width: 450px;
                            background: linear-gradient(135deg, rgba(255,255,255,0.9), rgba(255,255,255,0.6));
                            backdrop-filter: blur(20px);
                            border: 2px solid rgba(212, 175, 55, 0.5);
                            border-radius: 25px;
                            box-shadow: 0 25px 50px rgba(109, 27, 27, 0.15);
                            transform: rotateY(-10deg) rotateX(5deg);
                            transition: transform 0.5s ease;
                        " onmouseover="this.style.transform='rotateY(0deg) rotateX(0deg) scale(1.02)'" 
                          onmouseout="this.style.transform='rotateY(-10deg) rotateX(5deg)'">

                            <div class="position-absolute top-0 start-0 border-top border-start border-3 border-warning rounded-top-4" style="width: 50px; height: 50px; margin: 15px;"></div>
                            <div class="position-absolute bottom-0 end-0 border-bottom border-end border-3 border-warning rounded-bottom-4" style="width: 50px; height: 50px; margin: 15px;"></div>

                            <div class="text-center border border-2 border-secondary-subtle p-4 rounded-4" style="border-style: dashed !important;">
                                
                                <h6 class="text-secondary fw-bold text-uppercase ls-2 mb-1" style="letter-spacing: 3px; font-size: 0.7rem;">Official Event Pass</h6>
                                <h2 class="text-maroon fw-bold font-cinzel mb-0">MATH FAIR 2026</h2>
                                <div class="d-flex justify-content-center align-items-center gap-2 my-2">
                                    <div style="height: 1px; width: 30px; background: #d4af37;"></div>
                                    <i class="bi bi-star-fill text-warning" style="font-size: 0.8rem;"></i>
                                    <div style="height: 1px; width: 30px; background: #d4af37;"></div>
                                </div>

                                <div class="row mt-4 mb-4 g-2">
                                    <div class="col-6 text-start border-end">
                                        <small class="text-muted d-block" style="font-size: 0.7rem;">DATE</small>
                                        <strong class="text-dark fs-5 font-cinzel">13-14</strong>
                                        <span class="d-block fw-bold text-danger small">APRIL 2026</span>
                                    </div>
                                    <div class="col-6 text-start ps-3">
                                        <small class="text-muted d-block" style="font-size: 0.7rem;">LOCATION</small>
                                        <strong class="text-dark">Auditorium</strong>
                                        <span class="d-block fw-bold text-dark small">UNIMED</span>
                                    </div>
                                </div>

                                <div class="bg-light p-3 rounded-3 mb-3">
                                    <p class="mb-0 small fst-italic text-secondary font-playfair">
                                        "Journey of Numbers Through Time"
                                    </p>
                                </div>

                                <div class="d-flex justify-content-between align-items-end">
                                    <div class="text-start">
                                        <small class="text-muted" style="font-size: 0.65rem;">STATUS</small><br>
                                        <span class="badge bg-success bg-opacity-10 text-success border border-success px-2">OPEN REGISTRATION</span>
                                    </div>
                                    <i class="bi bi-qr-code-scan fs-1 text-dark opacity-25"></i>
                                </div>

                            </div>
                            
                            <div class="position-absolute top-50 start-0 translate-middle rounded-circle bg-white shadow-sm" style="width: 30px; height: 30px; margin-left: -2px;"></div>
                            <div class="position-absolute top-50 end-0 translate-middle rounded-circle bg-white shadow-sm" style="width: 30px; height: 30px; margin-right: -32px;"></div>

                        </div>
                    </div>
                </div>

                
                               

                    </div>
                </div>
    </section>

    <div id="tentang">
        <section class="story-section bg-white py-5">
            <div class="container py-4">
                <div class="row align-items-center">
                    <div class="col-lg-5 text-center mb-4 mb-lg-0" data-aos="fade-right">
                        <i class="bi bi-hourglass-split text-warning" style="font-size: 10rem; opacity: 0.8;"></i>
                    </div>
                    <div class="col-lg-7" data-aos="fade-left">
                        <div class="glass-card border-warning">
                            <h2 class="text-maroon fw-bold mb-3"><i class="bi bi-stars text-warning me-2"></i> TEMA: CHRONOMATH</h2>
                            <p class="text-muted" style="line-height: 1.8;">
                                Matematika Fair 2026 hadir dengan tema <strong>ChronoMath</strong>, sebuah perjalanan lintas waktu yang menelusuri jejak angka sejak peradaban awal manusia. Dari tanah Mesir Kuno hingga era digital, matematika tumbuh bersama peradaban.
                                <br><br>
                                Tema ini merepresentasikan bagaimana angka bukan sekadar simbol hitung, melainkan saksi sejarah dan fondasi kemajuan.
                                <br><br>
                                <em class="text-dark font-playfair">"ChronoMath mengajak kita kembali melihat masa lalu, memahami akar ilmu, dan melangkah ke masa depan dengan logika & inovasi."</em>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="story-section py-5" style="background: linear-gradient(135deg, #fffbf0 0%, #f3e5ab 100%);">
            <div class="container py-4">
                <div class="row align-items-center flex-column-reverse flex-lg-row">
                    <div class="col-lg-7" data-aos="fade-right">
                        <div class="glass-card">
                            <h2 class="text-maroon fw-bold mb-3"><i class="bi bi-gem text-danger me-2"></i> FILOSOFI LOGO</h2>
                            <p class="text-muted" style="line-height: 1.8;">
                                Logo ini bukan sekadar simbol, melainkan representasi dari <strong>semangat, perjalanan waktu, dan kejayaan ilmu matematika</strong>. Terinspirasi dari estetika Mesir Kuno yang agung.
                                <br><br>
                                Setiap elemen emas dan merah dirancang untuk menggambarkan matematika sebagai fondasi peradaban dan cahaya ilmu pengetahuan yang tak pernah padam.
                            </p>
                        </div>
                    </div>
                    <div class="col-lg-5 text-center mb-4 mb-lg-0" data-aos="zoom-in">
                        <img src="assets/img/logo_mathfair.jpeg" class="img-fluid rounded-circle shadow-lg border border-5 border-white" style="max-height: 350px;">
                    </div>
                </div>
            </div>
        </section>

        <section class="story-section bg-white py-5">
            <div class="container py-4">
                <div class="row align-items-center">
                    <div class="col-lg-5 text-center mb-4 mb-lg-0" data-aos="fade-up">
                        <img src="assets/img/maskot.jpg" class="img-fluid maskot-frame rounded-4" alt="Fennix Maskot">
                    </div>
                    <div class="col-lg-7" data-aos="fade-up" data-aos-delay="200">
                        <div class="glass-card" style="border-left: 5px solid var(--gold);">
                            <h2 class="text-dark fw-bold mb-3">🦊 KENALAN DENGAN FENNIX!</h2>
                            <p class="text-muted" style="line-height: 1.8;">
                                Maskot resmi Matematika Fair 2026! Terinspirasi dari <strong>Fennec Fox</strong>, Fennix melambangkan kecerdikan, ketelitian, dan kecepatan berpikir.
                                <br><br>
                                Dengan balutan nuansa Mesir Kuno, Fennix hadir sebagai pemandu yang siap menemani petualangan logikamu. Fennix adalah simbol kepercayaan diri dalam menghadapi tantangan.
                                <br><br>
                                <strong class="text-maroon">Siap bertualang bersama Fennix? ✨</strong>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <section id="galeri" class="py-5" style="background-color: var(--primary-dark);">
        <div class="container py-4">
            <div class="section-header" data-aos="fade-down">
                <h2 class="text-white">✨ SPECIAL MOMENTS</h2>
                <div class="divider-gold"></div>
                <p class="text-white-50 mt-3">Kilas balik keseruan dan semangat kompetisi tahun lalu.</p>
            </div>

            <div class="row g-4">
                <div class="col-md-4 col-sm-6" data-aos="zoom-in" data-aos-delay="100">
                    <img src="assets/img/doc1.jpg" class="gallery-img" alt="Momen 1">
                </div>
                <div class="col-md-4 col-sm-6" data-aos="zoom-in" data-aos-delay="200">
                    <img src="assets/img/doc2.jpg" class="gallery-img" alt="Momen 2">
                </div>
                <div class="col-md-4 col-sm-6" data-aos="zoom-in" data-aos-delay="300">
                    <img src="assets/img/doc3.jpg" class="gallery-img" alt="Momen 3">
                </div>
                <div class="col-md-4 col-sm-6" data-aos="zoom-in" data-aos-delay="400">
                    <img src="assets/img/doc4.jpg" class="gallery-img" alt="Momen 4">
                </div>
                <div class="col-md-4 col-sm-6" data-aos="zoom-in" data-aos-delay="500">
                    <img src="assets/img/doc5.jpg" class="gallery-img" alt="Momen 5">
                </div>
                <div class="col-md-4 col-sm-6" data-aos="zoom-in" data-aos-delay="600">
                    <img src="assets/img/doc6.jpg" class="gallery-img" alt="Momen 6">
                </div>
            </div>
        </div>
    </section>

    <section id="kategori" class="py-5" style="background-color: #f9f9f9;">
        <div class="container py-5">
            <div class="section-header" data-aos="fade-up">
                <h2>KATEGORI LOMBA</h2>
                <div class="divider-gold"></div>
            </div>
            
            <div class="row g-4 justify-content-center mb-4">
                <div class="col-md-4" data-aos="fade-up">
                    <div class="glass-card text-center h-100 bg-white">
                        <div class="mb-3 text-danger"><i class="bi bi-calculator fs-1"></i></div>
                        <h4 class="fw-bold">Olimpiade</h4>
                        <p class="text-muted small text-uppercase fw-bold">SD, SMP, SMA Sederajat</p>
                        <hr>
                        <p class="small text-secondary">Uji kemampuan analitis dan logika matematika secara individu.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                    <div class="glass-card text-center h-100 bg-white border-primary">
                        <div class="mb-3 text-primary"><i class="bi bi-people-fill fs-1"></i></div>
                        <h4 class="fw-bold">LCCM</h4>
                        <p class="text-muted small text-uppercase fw-bold">Cerdas Cermat SMA (Tim)</p>
                        <hr>
                        <p class="small text-secondary">Adu kecepatan dan ketepatan tim dalam menjawab soal.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                    <div class="glass-card text-center h-100 bg-white">
                        <div class="mb-3 text-info"><i class="bi bi-graph-up-arrow fs-1"></i></div>
                        <h4 class="fw-bold">Data Analysis</h4>
                        <p class="text-muted small text-uppercase fw-bold">Mahasiswa (Tim)</p>
                        <hr>
                        <p class="small text-secondary">Olah data menjadi insight yang tajam dan solutif.</p>
                    </div>
                </div>
            </div>

            <div class="row g-4 justify-content-center">
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="glass-card text-center h-100 bg-white">
                        <div class="mb-3 text-warning"><i class="bi bi-pie-chart-fill fs-1"></i></div>
                        <h4 class="fw-bold">SIC</h4>
                        <p class="text-muted small text-uppercase fw-bold">Infografis Statistik (Tim)</p>
                        <hr>
                        <p class="small text-secondary">Sajikan data statistik dalam visual yang menarik.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="400">
                    <div class="glass-card text-center h-100 bg-white">
                        <div class="mb-3 text-success"><i class="bi bi-palette-fill fs-1"></i></div>
                        <h4 class="fw-bold">Poster Ilmiah</h4>
                        <p class="text-muted small text-uppercase fw-bold">Desain Kreatif Mahasiswa</p>
                        <hr>
                        <p class="small text-secondary">Tuangkan ide ilmiah dalam poster yang edukatif.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="timeline" class="py-5 bg-white">
        <div class="container py-4">
            <div class="section-header" data-aos="fade-up">
                <h2>🗓️ TIMELINE LENGKAP</h2>
                <div class="divider-gold"></div>
            </div>
            
            <div class="row g-4">
                <div class="col-md-4" data-aos="fade-right">
                    <div class="timeline-card border-danger">
                        <h5 class="fw-bold text-danger text-uppercase">Olimpiade (Siswa)</h5>
                        <hr>
                        <ul class="list-unstyled timeline-list">
                            <li><span class="date-badge">17 Des - 25 Jan</span> Pendaftaran</li>
                            <li><span class="date-badge">02 Feb</span> Pertandingan</li>
                            <li><span class="date-badge">03 Feb</span> Pengumuman</li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-4" data-aos="fade-up">
                    <div class="timeline-card border-primary">
                        <h5 class="fw-bold text-primary text-uppercase">LCCM (SMA)</h5>
                        <hr>
                        <ul class="list-unstyled timeline-list">
                            <li><span class="date-badge">17 Des - 25 Jan</span> Pendaftaran</li>
                            <li><span class="date-badge">30 Jan</span> Technical Meeting</li>
                            <li><span class="date-badge">02 Feb</span> Penyisihan</li>
                            <li><span class="date-badge">03 Feb</span> Semifinal & Final</li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-4" data-aos="fade-left">
                    <div class="timeline-card border-success">
                        <h5 class="fw-bold text-success text-uppercase">Poster Ilmiah</h5>
                        <hr>
                        <ul class="list-unstyled timeline-list">
                            <li><span class="date-badge">17 Des - 25 Jan</span> Daftar & Upload</li>
                            <li><span class="date-badge">25 Jan - 31 Jan</span> Penilaian Juri</li>
                            <li><span class="date-badge">03 Feb</span> Pengumuman</li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
                    <div class="timeline-card border-warning">
                        <h5 class="fw-bold text-warning text-dark text-uppercase">SIC (Infografis)</h5>
                        <hr>
                        <ul class="list-unstyled timeline-list small">
                            <li><span class="date-badge">17 Des - 21 Jan</span> Pendaftaran & Kirim Karya</li>
                            <li><span class="date-badge">22 Jan - 25 Jan</span> Penilaian Karya</li>
                            <li><span class="date-badge">26 Jan</span> Pengumuman Finalis</li>
                            <li><span class="date-badge">27 Jan</span> TM & Kumpul PPT Awal</li>
                            <li><span class="date-badge">02 Feb</span> Final Presentasi</li>
                            <li><span class="date-badge">03 Feb</span> Pengumuman Juara</li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
                    <div class="timeline-card border-info">
                        <h5 class="fw-bold text-info text-uppercase">DAC (Data Analysis)</h5>
                        <hr>
                        <ul class="list-unstyled timeline-list small">
                            <li><span class="date-badge">17 Des - 21 Jan</span> Pendaftaran</li>
                            <li><span class="date-badge">16 Jan</span> Pembagian Dataset</li>
                            <li><span class="date-badge">24 Jan</span> Batas Pengumpulan</li>
                            <li><span class="date-badge">27 Jan</span> Pengumuman Finalis</li>
                            <li><span class="date-badge">02 Feb</span> Final Presentasi</li>
                            <li><span class="date-badge">03 Feb</span> Pengumuman Juara</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <footer class="bg-dark text-white py-5">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-6">
                    <h4 class="fw-bold text-gold" style="font-family: 'Cinzel', serif;">HMJ MATEMATIKA</h4>
                    <h5 class="fw-bold text-white-50" style="font-family: 'Cinzel', serif;">MATEMATIKA FAIR 2026</h5>
                    <p class="text-secondary small mt-3">
                        Universitas Negeri Medan (UNIMED)<br>
                        Membangun Generasi Emas Matematika yang Unggul dan Kompetitif.
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <h5 class="text-gold">HUBUNGI KAMI</h5>
                    <p class="mb-1 fs-5 fw-bold text-white">CP: LOIS</p>
                    <p class="mb-1"><i class="bi bi-whatsapp text-success"></i> +62 852 7027 3042</p>
                    <p class="mb-3"><i class="bi bi-envelope"></i> matematikafair2026@gmail.com</p>
                    <a href="https://wa.me/6285270273042" target="_blank" class="btn btn-outline-warning btn-sm rounded-pill px-4">
                        <i class="bi bi-chat-dots me-2"></i> Chat Panitia Sekarang
                    </a>
                </div>
            </div>
            <hr class="border-secondary mt-5">
            <div class="text-center text-secondary small">
                &copy; 2026 Matematika Fair. All Rights Reserved. Built with <i class="bi bi-heart-fill text-danger"></i> by Database Team.
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true
        });
    </script>
</body>
</html>