<?php 
include 'koneksi.php'; 
// ==========================================
// UBAH ID INI SESUAI TINGKATAN:
// 1 = SD
// 2 = SMP
// 3 = SMA
// ==========================================
$id_lomba_ini = 1; 

$info = mysqli_fetch_array(mysqli_query($koneksi, "SELECT * FROM tb_lomba WHERE id_lomba='$id_lomba_ini'"));
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar <?php echo $info['nama_lomba']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #fffbf0 0%, #ffeecf 100%);
            min-height: 100vh; padding: 40px 0;
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.5); border-radius: 25px;
            box-shadow: 0 15px 35px rgba(176, 0, 0, 0.15); /* Bayangan Merah */
        }
        .page-title { font-family: 'Cinzel', serif; color: #b00000; font-weight: 800; text-transform: uppercase; }
        .form-label { font-weight: 600; font-size: 0.9rem; color: #555; margin-bottom: 5px; }
        .input-group-text { background: #fff; border-right: none; border-radius: 12px 0 0 12px; color: #b00000; }
        .form-control { border-left: none; border-radius: 0 12px 12px 0; padding: 12px; font-size: 0.95rem; }
        .form-control:focus { box-shadow: none; border-color: #b00000; }
        .form-control:focus + .input-group-text { border-color: #b00000; }
        
        .btn-daftar {
            background: linear-gradient(45deg, #b00000, #800000); border: none; color: white;
            padding: 15px; border-radius: 50px; font-weight: bold; width: 100%; transition: 0.3s;
        }
        .btn-daftar:hover { transform: translateY(-3px); box-shadow: 0 10px 20px rgba(176, 0, 0, 0.3); background: linear-gradient(45deg, #800000, #b00000); color:white; }
        
        .section-header {
            background: linear-gradient(to right, #b00000, #d63333); color: white;
            padding: 10px 20px; border-radius: 10px; margin-bottom: 20px;
            display: inline-block; font-size: 0.9rem; font-weight: bold;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10">
            <div class="glass-card p-4 p-md-5">
                
                <div class="text-center mb-5">
                    <img src="assets/img/logo_unimed.jpg" width="60" class="rounded-circle mb-3 shadow-sm">
                    <h2 class="page-title"><?php echo $info['nama_lomba']; ?></h2>
                    <span class="badge bg-danger rounded-pill px-3 py-2 shadow-sm">
                        <i class="bi bi-person-fill me-1"></i> Kategori: Individu
                    </span>
                </div>
                
                <form action="proses_daftar.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="id_lomba" value="<?php echo $id_lomba_ini; ?>">
                    <input type="hidden" name="tipe_daftar" value="INDIVIDU">

                    <div class="mb-5">
                        <div class="section-header"><i class="bi bi-person-lines-fill me-2"></i> DATA DIRI PESERTA</div>
                        <div class="row g-3">
                            <div class="col-12">
                                <label class="form-label">Nama Lengkap</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-person"></i></span>
                                    <input type="text" name="nama" class="form-control" placeholder="Nama Sesuai Identitas" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">NISN / Nomor Induk sekolah</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-card-heading"></i></span>
                                    <input type="text" name="nomor_induk" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Jenis Kelamin</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-gender-ambiguous"></i></span>
                                    <select name="jk" class="form-select form-control" required>
                                        <option value="L">Laki-laki</option>
                                        <option value="P">Perempuan</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Asal Sekolah</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-building"></i></span>
                                    <input type="text" name="instansi" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Tanggal Lahir</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-calendar-date"></i></span>
                                    <input type="date" name="ttl" class="form-control" required>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label fw-bold text-danger">No. HP Orang Tua / Wali (Wajib)</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-danger text-white border-danger"><i class="bi bi-telephone-fill"></i></span>
                                    <input type="number" name="no_telp_wali" class="form-control border-danger" placeholder="08xxxxxxxx" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Email Aktif</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-envelope"></i></span>
                                    <input type="email" name="email" class="form-control" placeholder="email@contoh.com" required>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label class="form-label">Alamat Rumah</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-geo-alt"></i></span>
                                    <textarea name="alamat" class="form-control" rows="2" required></textarea>
                                </div>
                            </div>

                            <div class="col-12 mt-3">
                                <label class="form-label text-danger">Upload Kartu Pelajar / Pas foto </label>
                                <input type="file" name="foto" class="form-control" style="border-radius:12px;" required accept="image/*">
                            </div>
                        </div>
                    </div>

                    <div class="p-4 rounded-4 mb-4" style="background: rgba(176, 0, 0, 0.05); border: 1px dashed #b00000;">
                        <h5 class="fw-bold text-dark mb-3"><i class="bi bi-wallet2 me-2"></i> PEMBAYARAN</h5>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span>Biaya Pendaftaran:</span>
                            <span class="fs-4 fw-bold text-danger">Rp <?php echo number_format($info['biaya_daftar']); ?></span>
                        </div>
                        <div class="alert alert-light border shadow-sm">
                            <small class="text-muted d-block text-uppercase">Transfer ke Bank BNI</small>
                            <span class="fw-bold fs-5">1929266460</span><br>
                            <span>a.n. Aldha Aulia</span>
                        </div>
                        <label class="form-label mt-2">Upload Bukti Transfer</label>
                        <input type="file" name="bukti_bayar" class="form-control" style="border-radius:12px;" required accept="image/*">
                    </div>

                    <button type="submit" class="btn btn-daftar shadow-lg">
                        <i class="bi bi-send-check-fill me-2"></i> KIRIM FORMULIR
                    </button>
                    <div class="text-center mt-3">
                        <a href="pilih_lomba.php" class="text-muted text-decoration-none small"><i class="bi bi-arrow-left"></i> Kembali</a>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
</body>
</html>