<?php 
include 'koneksi.php'; 
$id_lomba_ini = 7; // ID Lomba Poster
$info = mysqli_fetch_array(mysqli_query($koneksi, "SELECT * FROM tb_lomba WHERE id_lomba='$id_lomba_ini'"));
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar <?php echo $info['nama_lomba']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body { font-family: 'Poppins', sans-serif; background: linear-gradient(135deg, #f0fff4 0%, #c6f6d5 100%); min-height: 100vh; padding: 40px 0; }
        .glass-card { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(20px); border: 1px solid rgba(255, 255, 255, 0.5); border-radius: 25px; box-shadow: 0 15px 35px rgba(47, 133, 90, 0.15); }
        .page-title { font-family: 'Cinzel', serif; color: #198754; font-weight: 800; text-transform: uppercase; }
        .form-label { font-weight: 600; font-size: 0.9rem; color: #555; margin-bottom: 5px; }
        .input-group-text { background: #fff; border-right: none; border-radius: 12px 0 0 12px; color: #198754; }
        .form-control { border-left: none; border-radius: 0 12px 12px 0; padding: 12px; font-size: 0.95rem; }
        .form-control:focus { box-shadow: none; border-color: #198754; }
        .form-control:focus + .input-group-text { border-color: #198754; }
        .section-header { background: linear-gradient(to right, #198754, #20c997); color: white; padding: 10px 20px; border-radius: 10px; margin-bottom: 20px; display: inline-block; font-weight: bold; }
        .btn-daftar { background: linear-gradient(45deg, #198754, #146c43); border: none; color: white; padding: 15px; border-radius: 50px; font-weight: bold; width: 100%; transition: 0.3s; }
        .btn-daftar:hover { transform: translateY(-3px); box-shadow: 0 10px 20px rgba(25, 135, 84, 0.3); background: linear-gradient(45deg, #146c43, #198754); color: white; }
    </style>
</head>
<body>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-lg-8 col-md-10">
            <div class="glass-card p-4 p-md-5">
                <div class="text-center mb-5">
                    <img src="assets/img/logo_unimed.jpg" width="60" class="rounded-circle mb-3 shadow-sm">
                    <h2 class="page-title"><?php echo $info['nama_lomba']; ?></h2>
                    <span class="badge bg-success rounded-pill px-3 py-2 shadow-sm"><i class="bi bi-palette-fill me-1"></i> Kategori: Mahasiswa</span>
                </div>
                
                <form action="proses_daftar.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="id_lomba" value="<?php echo $id_lomba_ini; ?>">
                    <input type="hidden" name="tipe_daftar" value="KARYA">

                    <div class="mb-5"><div class="section-header"><i class="bi bi-person-badge-fill me-2"></i> IDENTITAS KREATOR</div>
                        <div class="row g-3">
                            <div class="col-12"><label class="form-label">Nama Lengkap</label><div class="input-group"><span class="input-group-text"><i class="bi bi-person"></i></span><input type="text" name="nama" class="form-control" required></div></div>
                            <div class="col-md-6"><label class="form-label">NIM</label><div class="input-group"><span class="input-group-text"><i class="bi bi-card-heading"></i></span><input type="text" name="nomor_induk" class="form-control" required></div></div>
                            <div class="col-md-6"><label class="form-label">Asal Kampus</label><div class="input-group"><span class="input-group-text"><i class="bi bi-building"></i></span><input type="text" name="instansi" class="form-control" required></div></div>
                            <div class="col-md-6"><label class="form-label">WhatsApp</label><div class="input-group"><span class="input-group-text"><i class="bi bi-whatsapp"></i></span><input type="number" name="no_telp" class="form-control" required></div></div>
                            <div class="col-12"><label class="form-label">Alamat / Domisili</label><div class="input-group"><span class="input-group-text"><i class="bi bi-geo-alt"></i></span><textarea name="alamat" class="form-control" rows="2" required></textarea></div></div>
                        </div>
                    </div>

                    <div class="mb-5"><div class="section-header bg-warning text-dark"><i class="bi bi-cloud-arrow-up-fill me-2"></i> UPLOAD BERKAS</div>
                
                        <div class="mb-3"><label class="form-label text-success fw-bold"> Upload KTM</label><input type="file" name="foto" class="form-control" style="border-radius:12px;" required accept="image/*"></div>
                    </div>

                    <div class="mb-5">
                        <div class="section-header bg-info text-dark fw-bold" style="background: linear-gradient(to right, #0dcaf0, #0aa2c0); color:white !important;"><i class="bi bi-camera-fill me-2"></i> TWIBBON CHALLENGE</div>
                        <div class="p-3 rounded-4 border border-info bg-light shadow-sm">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h6 class="fw-bold text-dark">Ramaikan Acara! 🥳</h6>
                                    <p class="small text-muted mb-2">Pasang Twibbon jangan sampai salah caption ya</p>
                                    <div class="d-flex gap-2 flex-wrap">
                                        <a href="https://twb.nz/matematikafair2026" target="_blank" class="btn btn-sm btn-success text-white rounded-pill fw-bold shadow-sm">
                                            <i class="bi bi-camera me-1"></i> Pasang Twibbon
                                        </a>
                                        <a href="https://drive.google.com/drive/folders/1ObnNLXfNs5VEiODxSEU8LBmXOV41uQ5T" target="_blank" class="btn btn-sm btn-outline-success rounded-pill fw-bold shadow-sm">
                                            <i class="bi bi-google-drive me-1"></i> Ambil Caption
                                        </a>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-3 mt-md-0"><label class="form-label small fw-bold text-dark">Upload Screenshot</label><input type="file" name="bukti_twibbon" class="form-control" style="border-radius:12px;" accept="image/*"></div>
                            </div>
                        </div>
                    </div>

                    <div class="p-4 rounded-4 mb-4" style="background: rgba(25, 135, 84, 0.05); border: 1px dashed #198754;">
                        <h5 class="fw-bold text-dark mb-3"><i class="bi bi-wallet2 me-2"></i> PEMBAYARAN</h5>
                        <div class="d-flex justify-content-between align-items-center mb-2"><span>Biaya:</span><span class="fs-4 fw-bold text-success">Rp <?php echo number_format($info['biaya_daftar']); ?></span></div>
                        <div class="alert alert-light border shadow-sm"><span class="fw-bold">BNI 1929266460</span><br><span>a.n. Aldha Aulia</span></div>
                        <label class="form-label mt-2">Upload Bukti Transfer</label><input type="file" name="bukti_bayar" class="form-control" style="border-radius:12px;" required accept="image/*">
                    </div>

                    <button type="submit" class="btn btn-daftar shadow-lg"><i class="bi bi-send-check-fill me-2"></i> KIRIM KARYA</button>
                    <div class="text-center mt-3"><a href="pilih_lomba.php" class="text-muted text-decoration-none small">Kembali</a></div>
                </form>
            </div>
        </div>
    </div>
</div>
</body>
</html>