<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hall of Competition - Math Fair 2026</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <style>
        :root { --primary: #6d1b1b; --gold: #d4af37; --cream: #fffbf0; }
        body { background-color: var(--cream); font-family: 'Poppins', sans-serif; overflow-x: hidden; }
        /* HEADER MEWAH */
        .hall-header {
            background: linear-gradient(rgba(44, 11, 11, 0.95), rgba(109, 27, 27, 0.9)), url('assets/img/daftar.jpg');
            background-size: cover; background-position: center; padding: 80px 0; text-align: center; color: white;
            border-bottom: 5px solid var(--gold); margin-bottom: 50px;
        }
        .hall-title { font-family: 'Cinzel', serif; font-size: 3rem; color: var(--gold); text-shadow: 0 5px 15px rgba(0,0,0,0.5); }
        .btn-back { border: 1px solid var(--gold); color: var(--gold); border-radius: 50px; padding: 5px 20px; text-decoration: none; transition: 0.3s; }
        .btn-back:hover { background: var(--gold); color: #2c0b0b; }
        .section-label { display: inline-block; background: var(--primary); color: white; padding: 10px 30px; border-radius: 0 50px 50px 0; font-family: 'Cinzel', serif; font-size: 1.2rem; margin-bottom: 30px; border-left: 5px solid var(--gold); }
        .card-lomba { border: none; border-radius: 20px; background: white; box-shadow: 0 10px 30px rgba(0,0,0,0.05); transition: 0.4s; overflow: hidden; position: relative; height: 100%; }
        .card-lomba:hover { transform: translateY(-10px); box-shadow: 0 20px 40px rgba(109, 27, 27, 0.15); }
        .bar-olim { background: linear-gradient(45deg, #d4af37, #b8860b); height: 10px; width: 100%; }
        .bar-lccm { background: linear-gradient(45deg, #6d1b1b, #902e2e); height: 10px; width: 100%; }
        .bar-mhs  { background: linear-gradient(45deg, #1b366d, #2c4a8a); height: 10px; width: 100%; }
        .card-body { padding: 30px 20px; text-align: center; }
        .icon-lomba { font-size: 3rem; margin-bottom: 15px; display: inline-block; }
        .lomba-title { font-weight: 700; color: #333; font-size: 1.1rem; margin-bottom: 5px; }
        .price-tag { font-family: 'Cinzel', serif; font-size: 1.5rem; color: var(--primary); font-weight: 900; display: block; margin-bottom: 20px; }
        .btn-daftar { display: block; width: 100%; padding: 12px; border-radius: 12px; font-weight: bold; text-transform: uppercase; letter-spacing: 1px; transition: 0.3s; text-decoration: none; border: none; }
        .btn-gold { background: var(--cream); color: #b8860b; border: 2px solid #b8860b; }
        .btn-gold:hover { background: #b8860b; color: white; }
        .btn-maroon { background: var(--cream); color: var(--primary); border: 2px solid var(--primary); }
        .btn-maroon:hover { background: var(--primary); color: white; }
        .btn-navy { background: #f0f4ff; color: #1b366d; border: 2px solid #1b366d; }
        .btn-navy:hover { background: #1b366d; color: white; }
        .badge-jenjang { position: absolute; top: 20px; right: 20px; font-size: 0.7rem; padding: 5px 12px; border-radius: 20px; }
    </style>
</head>
<body>
    <div class="hall-header">
        <div class="container">
            <h1 class="hall-title" data-aos="zoom-in">HALL OF COMPETITION</h1>
            <p class="text-white opacity-75 mb-4">Pilih kategori lomba dan jadilah juara!</p>
            <a href="index.php" class="btn-back"><i class="bi bi-arrow-left"></i> Kembali ke Lobby</a>
        </div>
    </div>
    <div class="container pb-5">
        
        <div data-aos="fade-right"><div class="section-label">OLIMPIADE SISWA</div></div>
        <div class="row g-4 mb-5">
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                <div class="card-lomba">
                    <div class="bar-olim"></div><span class="badge bg-warning text-dark badge-jenjang">SD</span>
                    <div class="card-body">
                        <i class="bi bi-calculator icon-lomba text-warning"></i><h4 class="lomba-title">OLIMPIADE MATEMATIKA</h4><span class="price-tag">Rp 55.000</span>
                        <a href="kamar_olimpiade_sd.php" class="btn-daftar btn-gold">DAFTAR SEKARANG <i class="bi bi-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card-lomba">
                    <div class="bar-olim"></div><span class="badge bg-warning text-dark badge-jenjang">SMP</span>
                    <div class="card-body">
                        <i class="bi bi-journal-album icon-lomba text-warning"></i><h4 class="lomba-title">OLIMPIADE MATEMATIKA</h4><span class="price-tag">Rp 65.000</span>
                        <a href="kamar_olimpiade_smp.php" class="btn-daftar btn-gold">DAFTAR SEKARANG <i class="bi bi-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                <div class="card-lomba">
                    <div class="bar-olim"></div><span class="badge bg-warning text-dark badge-jenjang">SMA</span>
                    <div class="card-body">
                        <i class="bi bi-infinity icon-lomba text-warning"></i><h4 class="lomba-title">OLIMPIADE MATEMATIKA</h4><span class="price-tag">Rp 75.000</span>
                        <a href="kamar_olimpiade_sma.php" class="btn-daftar btn-gold">DAFTAR SEKARANG <i class="bi bi-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </div>

        <div data-aos="fade-right"><div class="section-label">KOMPETISI TIM</div></div>
        <div class="row g-4 mb-5">
            <div class="col-md-12" data-aos="zoom-in">
                <div class="card-lomba d-flex flex-column flex-md-row align-items-center">
                    <div class="d-none d-md-block" style="width: 10px; height: 100%; background: linear-gradient(to bottom, #6d1b1b, #902e2e);"></div> 
                    <div class="p-4 text-center text-md-start flex-grow-1">
                        <span class="badge bg-danger mb-2">KHUSUS SMA / SEDERAJAT</span>
                        <h3 class="fw-bold text-dark mb-2">LCCM MATEMATIKA</h3>
                        <p class="text-muted mb-0">Lomba Cerdas Cermat Matematika (1 Tim = 3 Orang).</p>
                    </div>
                    <div class="p-4 text-center" style="background: #fffbf0; min-width: 250px; height: 100%;">
                        <span class="price-tag mb-3" style="font-size: 2rem;">Rp 90.000</span>
                        <a href="kamar_lcc.php" class="btn-daftar btn-maroon shadow">DAFTAR TIM <i class="bi bi-trophy-fill ms-2"></i></a>
                    </div>
                </div>
            </div>
        </div>

        <div data-aos="fade-right"><div class="section-label">MAHASISWA & UMUM</div></div>
        <div class="row g-4">
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                <div class="card-lomba">
                    <div class="bar-mhs"></div><span class="badge bg-primary badge-jenjang">Mahasiswa</span>
                    <div class="card-body">
                        <i class="bi bi-pie-chart icon-lomba text-primary"></i><h4 class="lomba-title">SIC</h4><span class="price-tag">Rp 65.000</span>
                        <a href="kamar_sic.php" class="btn-daftar btn-navy">DAFTAR SEKARANG</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                <div class="card-lomba">
                    <div class="bar-mhs"></div><span class="badge bg-primary badge-jenjang">Mahasiswa</span>
                    <div class="card-body">
                        <i class="bi bi-graph-up-arrow icon-lomba text-primary"></i><h4 class="lomba-title">DAC</h4><span class="price-tag">Rp 65.000</span>
                        <a href="kamar_dac.php" class="btn-daftar btn-navy">DAFTAR SEKARANG</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                <div class="card-lomba">
                    <div class="bar-mhs"></div><span class="badge bg-success badge-jenjang">Mahasiswa</span>
                    <div class="card-body">
                        <i class="bi bi-palette icon-lomba text-success"></i><h4 class="lomba-title">POSTER</h4><span class="price-tag">Rp 30.000</span>
                        <a href="kamar_poster.php" class="btn-daftar btn-navy">DAFTAR SEKARANG</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>AOS.init();</script>
</body>
</html>